#!/bin/bash -f
# Copyright © 2018-2025, Spillbox. All rights reserved.
# Property of Spillbox Inc.
# Any kind of copying or producing derivative work is prohibited without
# explicit written consent from Spillbox Inc.

#-----------------------------------------------------------------------
#Description:  This script is used to pull the docker image in the current machine.
#-----------------------------------------------------------------------

#1:webserversip 2:service_userid

WEBSERVER_IP="$1"
SERVICE_USERID="$2"

SERVICE_USERNAME=$(echo $SERVICE_USERID | awk -F ':' '{print $3}')

if [ "$SERVICE_USERID" == "" ] ; then
    FREE_UID=$(awk -F: '{uid[$3]=1}END{for(x=2000;x<=10000;x++)if(!uid[x]){print x;exit}}' /etc/passwd /etc/group)
    sudo groupadd -g $FREE_UID $SERVICE_USERNAME
    sudo useradd -u $FREE_UID -g $FREE_UID $SERVICE_USERNAME
else
    USER_ID=$(echo $SERVICE_USERID | awk -F ':' '{print $1}')
    GROUP_ID=$(echo $SERVICE_USERID | awk -F ':' '{print $2}')
    sudo groupadd -g $GROUP_ID $SERVICE_USERNAME
    sudo useradd -u $USER_ID -g $GROUP_ID $SERVICE_USERNAME
fi

#Adding user to docker
sudo usermod -aG docker "$SERVICE_USERNAME"

#Pulling  created IMAGE to Webserver node and IMAGE node
sudo su - "${SERVICE_USERNAME}" -c "docker pull $1:5000/spillbox"
RET=$?
if test $RET -ne 0; then
    echo "Docker pull failed..."
fi

sudo su - "${SERVICE_USERNAME}" -c "docker tag $1:5000/spillbox spillbox"
