# Copyright © 2018-2025, Spillbox. All rights reserved.
# Property of Spillbox Inc.
# Any kind of copying or producing derivative work is prohibited without
# explicit written consent from Spillbox Inc.

terraform {
  required_version = ">= 1.10.4, < 1.10.5"
  required_providers {
    google = {
        version = "6.19.0"
    }
    null = {
        version = "3.2.3"
    }
    template = {
        version = "2.2.0"
    }
  }
}

provider "google" {
  region      = var.region
  project     = var.project
  credentials = var.google_credentials
}

resource "google_compute_instance" "host_image" {
  project      = var.project
  zone         = var.zone
  machine_type = var.image_instance_type == "" ? "n1-standard-2" : var.image_instance_type

  boot_disk {
    kms_key_self_link = var.kms_key_id == "" ? null : var.kms_key_id
    initialize_params {
      image = var.docker_ami_id
      size  = var.image_root_volume_size
    }
  }
  metadata = {
    serial-port-enable      = "true"
    block-project-ssh-keys  = "true"
    enable-guest-attributes = "TRUE"
    ssh-keys                = <<EOF
${var.ami_user}:${replace(file(var.project_public_key), "\n", "")} ${var.ami_user}
EOF

}

  network_interface {
    subnetwork         = var.subnet_id
    subnetwork_project = var.project
    dynamic "access_config" {
      for_each = var.disable_compute_public_ips == true ? [] : [1]
      content {}
    }
  }
  name                    = "spillbox-${var.imagetag}-hostimage"
#  metadata_startup_script = data.template_cloudinit_config.config.rendered
}
resource "null_resource" "build_host_image" {
  depends_on    = [google_compute_instance.host_image]
  connection {
    user        = var.ami_user
    private_key = file(var.project_private_key)
    host        = element(flatten(google_compute_instance.host_image.*.network_interface.0.network_ip), 0)
    port        = var.cloud_ssh_port
    timeout     = "600s"
  }

 provisioner "file" {
   source      = "${path.module}/../../../install"
   destination = "/tmp"
  }

  provisioner "file" {
   source      = "${path.module}/install"
   destination = "/tmp"
  }

  provisioner "remote-exec" {
    inline = [ "chmod 755 /tmp/install/install.sh ; /tmp/install/install.sh '${var.repo_dir}' '${var.gpg_dir}'"]
  }
}
