variable "zone" {}
variable "docker_ami_id" {
  description = "The ID of the Amazon Machine Image (AMI)."
}
variable "image_root_volume_size" {
  description = "The size of the volume in GB."
}
variable "subnet_id" {
  description = "The ID of the subnet in which the instance is launched."
}
variable "vpc_id" {
  description = "The ID of the VPC."
}
variable "region" {
  description = "The AWS region to deploy resources in."
}
variable "image_instance_type" {}
variable "instance_type" {
  description = "Instance type for the EC2 instance"
  type        = string
  default     = "n1-standard-2"
}
variable "imagetag" {
  description = "Image Tag name"
}
variable "cloud_ssh_port" {
  description = "The SSH port for the instance"
  type        = number
  default     = 22
}
variable "disable_compute_public_ips" {
  default = true
}

variable "ami_user" {}
variable "kms_key_id" {}
variable "project" {}
variable "google_credentials" {}
variable "project_private_key" {}
variable "project_public_key" {}
variable "repo_dir" {}
variable "gpg_dir" {}
