#!/bin/bash -f

# Copyright © 2018-2023, Spillbox. All rights reserved.
# Property of Spillbox Inc.
# Any kind of copying or producing derivative work is prohibited without
# explicit written consent from Spillbox Inc.

SUBNET=`ip route get 8.8.8.8 | awk '{print $3}'`
PREFIX=24


#Get the IP address of first ethernet interface for bond0 IP ET=eth1 

#ET=`ip -br l | awk '/UP/ $1 !~ "lo|vir|wl|eth0|enP|enp|docker0" { print $1}' | head -n1`
#DEFAULTROUTE=`ip route show | awk '/'$ET'/ {print $1}'| awk '{print $1}' | tail -n+2 |head -1`
#DEFAULTROUTE=`ip route show | grep link | grep -v eth0 | awk '{print $1}'`
#BOND0IP= `ifconfig "$ET" |awk ' /inet / {print $2}'`

ET=`ip -br l | grep ^eth | grep -w UP | grep -v eth0 | head -1 |awk '{print $1}'`
DEFAULTROUTE=`ip route show | awk '/'$ET'/ {print $1}'| awk '{print $1}'| head -1`

## if multiple ethernet doesn't exist it will error/exit 
if [ -z "$ET" ]; then
	echo " There is no interfaces to proceed with bonding"
	exit 1
fi

## Bond0 will get the first ethernet interface IP address
if [ $# -eq 0 ] 
  then BONDIP=`ip -o -f inet addr show "$ET" | awk '/scope global/ {print $4}'`
          echo $BONDIP
else
        BONDIP=$1/24
fi


## uncomment if network-manager not installed 
sudo apt-get -y install network-manager
sudo apt-get -y  install ifenslave

## In Ubuntu 18.04 there is a bug adding bon0 to system, workround is to touch 
## 10-globally-managed-device.conf file. Uncomment the following line.
if [ ! -f /etc/NetworkManager/conf.d/10-globally-managed-devices.conf ]
then
	sudo touch /etc/NetworkManager/conf.d/10-globally-managed-devices.conf
fi

## Restart the network manager
#sudo /etc/init.d/networking restart
sudo service network-manager restart
sudo systemctl start NetworkManager.service

nmcli device status  ## Debug 
sleep 10  ##Debug

## Multiple ethernet Interface in same subnet
sudo sysctl -w net.ipv4.conf.all.arp_filter=1
sudo grep -qF "net.ipv4.conf.all.arp_filter = 1" "/etc/sysctl.conf" ||  echo "net.ipv4.conf.all.arp_filter = 1" | sudo tee -a "/etc/sysctl.conf"


## Add the bond0 with mode 4 and IP address of first Network Interface 
## Bring up slave ethernet ports. Trying it for three times to make sure ports are up
sudo nmcli con add type bond con-name bond0 ifname bond0 mode 802.3ad ip4 $BONDIP

#for ethN in ip -br l | awk ' $1 !~ "lo|vir|wl|eth0|enP|bond0|docker0" { print $1}'
##
for ethN in `ip -br l | grep ^eth | grep -w UP | grep -v eth0 |awk '{print $1}'`
do
       sudo nmcli con add type bond-slave ifname $ethN master bond0
       
	#Some instances the connection up fails and multiple runs required
	for rec in {1..3}
	do	 
		sudo nmcli connection up bond-slave-$ethN      
		if [ $? -eq 0 ]; then 
			continue 
		fi
	done 	          
done


## Bring up bond0 connection
## Trying it for three times to make sure bond0 is up
for rec in {1..3}
do
	sudo nmcli connection  up bond0
	if [ $? -ne 0 ]; then
	       continue 
        fi
done

# If eth1 gets added 
#sudo nmcli con del $ET

nmcli con show  ## Debug 

ifconfig -a
sleep 10
ifconfig -a 

#printf "%s\t%s\n" "3" "bond0" >> sudo /etc/iproute2/rt_tables
sudo grep -qF "bond0" "/etc/iproute2/rt_tables" ||  echo "1  bond0" | sudo tee -a "/etc/iproute2/rt_tables"
#echo -e "1 \t bond0" | sudo tee -a /etc/iproute2/rt_tables
cat /etc/iproute2/rt_tables    ## Debug 


## Setup - Bond0 route  
BOND0IP=`ifconfig "$ET" |awk ' /inet / {print $2}'`
sudo ip route add default via $SUBNET table bond0
sudo ip rule add from $BOND0IP table bond0
sudo ip route add $DEFAULTROUTE dev bond0 src $BOND0IP table  bond0
#sudo ip route add $DEFAULTROUTE/$PREFIX dev bond0 src $BOND0IP table  bond0

## Restart NetworkManger 
#sudo /etc/init.d/networking restart
sudo service network-manager restart
sudo systemctl start NetworkManager.service

