#!/bin/bash -f
# Check if Docker is installed
if ! command -v docker &> /dev/null; then
    echo "Docker is not installed. Please install Docker before running this script."
    exit 1
fi
# Check if the OS is CentOS 8 or Ubuntu
    centos_version=$(cat /etc/os-release | grep -E 'VERSION_ID' | awk -F = '{print $2}' | sed 's/"//g')
if [ "$centos_version" != "7" ]; then
    echo "CentOS 8 or Ubuntu detected. Exiting script."
    exit 0
fi

docker_info=$(docker info 2>&1)
docker_root_dir=$(echo "$docker_info" | grep -oP 'Docker Root Dir:\s*\K\S+')

available_space=$(df -k "$docker_root_dir" | awk 'NR==2 {gsub("%","",$4); print $4}' | grep -o '[0-9]*')
# Set the threshold
threshold=$((15 * 1024 * 1024))
# Convert the threshold to gigabytes
threshold_gb=$((threshold / (1024 * 1024)))

# Check if available space is less than the threshold
if [ "$available_space" -lt "$threshold" ]; then
    echo "Warning: $docker_root_dir space is less than $threshold_gb GB. Docker image will take around 6GB of size"
    read -p "Do you want to continue? (yes/no): " choice
    if [ "$choice" == "no" ]; then
        exit 1
    fi
fi
#Define the Dockerfile name
DOCKERFILE=$(pwd)/dockerfile
# Create the Dockerfile
echo "FROM centos:$centos_version" > $DOCKERFILE
# List of packages to install
cat >> $DOCKERFILE << End
ENV container docker
MAINTAINER info@spillbox.io

RUN sed -i s/mirror.centos.org/vault.centos.org/g /etc/yum.repos.d/*.repo
RUN sed -i s/^#.*baseurl=http/baseurl=http/g /etc/yum.repos.d/*.repo
RUN sed -i s/^mirrorlist=http/#mirrorlist=http/g /etc/yum.repos.d/*.repo

RUN yum -y update; yum clean all
RUN yum -y install epel-release && yum -y install jq
RUN yum -y install sudo
RUN yum -y install csh
RUN yum -y install wget make gcc

RUN yum -y install asciidoc xmlto libbsd-devel libnet libnet-devel protobuf protobuf-c protobuf-c-devel protobuf-compiler protobuf-devel protobuf-python libnl3-devel libcap-devel python3 nftables
RUN (cd /tmp/; wget --no-check-certificate https://s3.us-west-1.amazonaws.com/spillbox.io-public/criu/criu.tar; tar xvf criu.tar; cp static/criu /usr/bin/criu )

RUN curl -sSL https://d.juicefs.com/install | sh -

VOLUME ["/sys/fs/cgroup"]
VOLUME ["/run"]
End
chunk=1000
index=0
command="RUN yum -y install"
for line in $(rpm -qa --queryformat "%{NAME}-%{VERSION} ")
do
    if test $index -gt $chunk; then
        echo $command
        index=0
        command="RUN yum -y install"
    fi
    command="$command $line"
    ((index++))
done
echo $command >> $DOCKERFILE
echo $DOCKERFILE created
echo Run the following command to build docker image: " docker build -f '$DOCKERFILE' -t '<IMAGE_NAME>' . "
