# Copyright © 2018-2023, Spillbox. All rights reserved.
# Property of Spillbox Inc.
# Any kind of copying or producing derivative work is prohibited without
# explicit written consent from Spillbox Inc.


# Some notes about running this file:
# Need to have AWS CLI installed and set up with your credentials.
# Need to have boto3 installed and Python 3 with version >= 3.7
# You can install boto3 with: pip3 install boto3.
import boto3 
import re
import os


ec2 = boto3.resource('ec2')
client = boto3.client('ec2')

# The id_full functions create the list without filtering out only terraform resources.

def instance_state_count():
    count = 0
    for instance in ec2.instances.all():
        if instance.tags:
            if instance.state['Name'] == "running":
                count+=1
    return count

def list_instance_id_name():
    instanceList = []
    instanceIDList = []
    instanceStateList = []
    for instance in ec2.instances.all():
        if instance.tags:
            instanceIDList.append(instance.instance_id)
            instanceStateList.append(instance.state['Name'])
            for tag in instance.tags:
                if tag['Key'] == 'Name':
                    instanceList.append(tag['Value'])
        else:
            instanceList.append("None")
            instanceIDList.append(instance.instance_id)
            instanceStateList.append(instance.state['Name'])
    mergedList = [(instanceList[i], instanceIDList[i], instanceStateList[i]) for i in range(0, len(instanceList))]
    return mergedList

def list_instance():
    instanceList = []
    for instance in ec2.instances.all():
        if instance.state['Name'] == "running":
            if instance.tags:
                for tag in instance.tags:
                    if tag['Key'] == 'Name':
                        val = tag['Value']
                        if val[0].isdigit() == True:
                            instanceList.append(tag['Value'])
    return instanceList

# Cuts the instances that start with a number to just that number. ex

def instance_cut():
    i_list = list_instance()
    ins_list = []
    for s in i_list: 
        pattern = re.compile('(-[^-]*){3}$')
        ins_list.append(pattern.sub('', s))
    return ins_list


def list_security_groups():
    security_groupList = []
    for security_group in ec2.security_groups.all():
        if security_group.tags:
            for tag in security_group.tags:
                if tag['Key'] == 'Name':
                    val = tag['Value']
                    if val[0].isdigit() == True:
                        security_groupList.append(tag['Value'])
    return security_groupList

def list_security_groups_id_name():
    security_groupList = []
    security_groupIDList = []
    for security_group in ec2.security_groups.all():
        if security_group.tags:
            security_groupIDList.append(security_group.group_id)
            for tag in security_group.tags:
                if tag['Key'] == 'Name':
                    security_groupList.append(tag['Value'])
    mergedList = [(security_groupList[i], security_groupIDList[i]) for i in range(0, len(security_groupList))]
    return mergedList

def list_security_groups_id_name_full():
    security_groupList = []
    security_groupIDList = []
    for security_group in ec2.security_groups.all():
        if security_group.tags:
            security_groupIDList.append(security_group.group_id)
            for tag in security_group.tags:
                if tag['Key'] == 'Name':
                    security_groupList.append(tag['Value'])
        else:
            security_groupList.append("None")
            security_groupIDList.append(security_group.group_id)
    mergedList = [(security_groupList[i], security_groupIDList[i]) for i in range(0, len(security_groupList))]
    return mergedList

def list_volumes():
    volumes_List = []
    for volume in ec2.volumes.all():
        if volume.tags:
            for tag in volume.tags:
                if tag['Key'] == 'Name':
                    val = tag['Value']
                    if val[0].isdigit() == True:
                        volumes_List.append(tag['Value'])
    return volumes_List

def list_volumes_id_name():
    volumes_List = []
    volumes_IDList = []
    for volume in ec2.volumes.all():
        if volume.tags:
            volumes_IDList.append(volume.volume_id)
            for tag in volume.tags:
                if tag['Key'] == 'Name':
                    volumes_List.append(tag['Value'])
    mergedList = [(volumes_List[i], volumes_IDList[i]) for i in range(0, len(volumes_List))]
    return mergedList

def list_volumes_id_name_full():
    volumes_List = []
    volumes_IDList = []
    for volume in ec2.volumes.all():
        if volume.tags:
            volumes_IDList.append(volume.volume_id)
            for tag in volume.tags:
                if tag['Key'] == 'Name':
                    volumes_List.append(tag['Value'])
        else:
            volumes_List.append("None")
            volumes_IDList.append(volume.volume_id)
    mergedList = [(volumes_List[i], volumes_IDList[i]) for i in range(0, len(volumes_List))]
    return mergedList

def list_nacls():
    naclList = []
    for nacl in ec2.network_acls.all():
        if nacl.tags:
            for tag in nacl.tags:
                if tag['Key'] == 'Name':
                    val = tag['Value']
                    if val[0].isdigit() == True:
                        naclList.append(tag['Value'])
    return naclList

def list_nacls_id_name():
    naclList = []
    naclIDList = []
    for nacl in ec2.network_acls.all():
        if nacl.tags:
            naclIDList.append(nacl.id)
            for tag in nacl.tags:
                if tag['Key'] == 'Name':
                    naclList.append(tag['Value'])
    mergedList = [(naclList[i], naclIDList[i]) for i in range(0, len(naclList))]
    return mergedList

def list_nacls_id_name_full():
    naclList = []
    naclIDList = []
    for nacl in ec2.network_acls.all():
        if nacl.tags:
            naclIDList.append(nacl.id)
            for tag in nacl.tags:
                if tag['Key'] == 'Name':
                    naclList.append(tag['Value'])
        else:
            naclList.append("None")
            naclIDList.append(nacl.id)
    mergedList = [(naclList[i], naclIDList[i]) for i in range(0, len(naclList))]
    return mergedList

def list_internet_gateways():
    internet_gatewayList = []
    for internet_gateway in ec2.internet_gateways.all():
        if internet_gateway.tags:
            for tag in internet_gateway.tags:
                if tag['Key'] == 'Name':
                    val = tag['Value']
                    if val[0].isdigit() == True:
                        internet_gatewayList.append(tag['Value'])
    return internet_gatewayList

def list_internet_gateways_id_name():
    internet_gatewayList = []
    internet_gatewayIDList = []
    for internet_gateway in ec2.internet_gateways.all():
        if internet_gateway.tags:
            internet_gatewayIDList.append(internet_gateway.id)
            for tag in internet_gateway.tags:
                if tag['Key'] == 'Name':
                    internet_gatewayList.append(tag['Value'])
    mergedList = [(internet_gatewayList[i], internet_gatewayIDList[i]) for i in range(0, len(internet_gatewayList))]
    return mergedList

def list_internet_gateways_id_name_full():
    internet_gatewayList = []
    internet_gatewayIDList = []
    for internet_gateway in ec2.internet_gateways.all():
        if internet_gateway.tags:
            internet_gatewayIDList.append(internet_gateway.id)
            for tag in internet_gateway.tags:
                if tag['Key'] == 'Name':
                    internet_gatewayList.append(tag['Value'])
        else:
            internet_gatewayList.append("None")
            internet_gatewayIDList.append(internet_gateway.id)
    mergedList = [(internet_gatewayList[i], internet_gatewayIDList[i]) for i in range(0, len(internet_gatewayList))]
    return mergedList

def list_route_tables():
    routeTableList = []
    for route_table in ec2.route_tables.all():
        if route_table.tags:
            for tag in route_table.tags:
                if tag['Key'] == 'Name':
                    val = tag['Value']
                    if val[0].isdigit() == True:
                        routeTableList.append(tag['Value'])
    return routeTableList

def list_route_tables_id_name():
    routeTableList = []
    routeTableIDList = []
    for route_table in ec2.route_tables.all():
        if route_table.tags:
            routeTableIDList.append(route_table.id)
            for tag in route_table.tags:
                if tag['Key'] == 'Name':
                    routeTableList.append(tag['Value'])
    mergedList = [(routeTableList[i], routeTableIDList[i]) for i in range(0, len(routeTableList))]
    return mergedList

def list_route_tables_id_name_full():
    routeTableList = []
    routeTableIDList = []
    for route_table in ec2.route_tables.all():
        if route_table.tags:
            routeTableIDList.append(route_table.id)
            for tag in route_table.tags:
                if tag['Key'] == 'Name':
                    routeTableList.append(tag['Value'])
        else:
            routeTableList.append("None")
            routeTableIDList.append(route_table.id)
    mergedList = [(routeTableList[i], routeTableIDList[i]) for i in range(0, len(routeTableList))]
    return mergedList

def list_subnets():
    subnetList = []
    for subnet in ec2.subnets.all():
        if subnet.tags:
            for tag in subnet.tags:
                if tag['Key'] == 'Name':
                    val = tag['Value']
                    if val[0].isdigit() == True:
                        subnetList.append(tag['Value'])
    return subnetList

def list_subnets_id_name():
    subnetList = []
    subnetIDList = []
    for subnet in ec2.subnets.all():
        if subnet.tags:
            subnetIDList.append(subnet.id)
            for tag in subnet.tags:
                if tag['Key'] == 'Name':
                    subnetList.append(tag['Value'])
    mergedList = [(subnetList[i], subnetIDList[i]) for i in range(0, len(subnetList))]
    return mergedList

def list_subnets_id_name_full():
    subnetList = []
    subnetIDList = []
    for subnet in ec2.subnets.all():
        if subnet.tags:
            subnetIDList.append(subnet.id)
            for tag in subnet.tags:
                if tag['Key'] == 'Name':
                    subnetList.append(tag['Value'])
        else:
            subnetList.append("None")
            subnetIDList.append(subnet.id)
    mergedList = [(subnetList[i], subnetIDList[i]) for i in range(0, len(subnetList))]
    return mergedList

def list_vpcs():
    vpcList = []
    for vpc in ec2.vpcs.all():
        if vpc.tags:
            for tag in vpc.tags:
                if tag['Key'] == 'Name':
                    val = tag['Value']
                    if val[0].isdigit() == True:
                        vpcList.append(tag['Value'])
    return vpcList

def list_vpcs_id_name():
    vpcList = []
    vpcIDList = []
    for vpc in ec2.vpcs.all():
        if vpc.tags:
            vpcIDList.append(vpc.id)
            for tag in vpc.tags:
                if tag['Key'] == 'Name':
                    vpcList.append(tag['Value'])
    mergedList = [(vpcList[i], vpcIDList[i]) for i in range(0, len(vpcList))]
    return mergedList

def list_vpcs_id_name_full():
    vpcList = []
    vpcIDList = []
    for vpc in ec2.vpcs.all():
        if vpc.tags:
            vpcIDList.append(vpc.id)
            for tag in vpc.tags:
                if tag['Key'] == 'Name':
                    vpcList.append(tag['Value'])
        else:
            vpcList.append("None")
            vpcIDList.append(vpc.id)
    mergedList = [(vpcList[i], vpcIDList[i]) for i in range(0, len(vpcList))]
    return mergedList

# Key Pairs not working.

def list_key_pairs():
    key_pairs_List = []
    for key_pair in ec2.key_pairs.all():
        key_pairs_List.append(key_pair.name)
    #print(key_pairs_List)
    return key_pairs_List

def list_key_pairs_id_name():
    key_pairs_List = []
    key_pairs_IDList = []
    for key_pair in ec2.key_pairs.all():
        key_pairs_List.append(key_pair.name)
        key_pairs_IDList.append(key_pair.key_pair_id)
    mergedList = [(key_pairs_List[i], key_pairs_IDList[i]) for i in range(0, len(key_pairs_List))]
    return mergedList

# This function is to just print out the list of tuples returned from the finalList functions.

def list_iterate_customer_unused(list):
    print("\n")
    t_size = os.get_terminal_size()
    print('-' * t_size.columns)
    count = 0
    if (len(list) == 0):
        print("no excess customer resources")
    for x in list:
        for y in x:
            if count == 0:
                print("Name: " + y)
                count += 1
            elif count == 1:
                print("ID: " + y)
                count += 1
            elif count == 2:
                print("State: " + y)
                count += 1
        count = 0
        print()
    print('-' * t_size.columns)
        
# Functions for name matching, the final list, and printing those lists below.

def name_matchSG():
    listDuplicated = []
    listIns = instance_cut()
    listSg = list_security_groups()
    if not listIns:
        for sg in listSg:
            listDuplicated.append(sg)
    else:
        for sg in listSg:
            for ins in listIns:
                if ins in sg:
                    continue
                listDuplicated.append(sg)
    listClean =  [*set(listDuplicated)]
    #print(listClean)
    return listClean

def final_listSG():
    mergeList = list_security_groups_id_name()
    compareList = name_matchSG()
    finalList = [tup for tup in mergeList if any(i in tup for i in compareList)]
    return finalList

def print_listSG():
    list = final_listSG()
    return list_iterate_customer_unused(list)

def name_matchVol():
    listDuplicated = []
    listIns = instance_cut()
    listV = list_volumes()
    if not listIns:
        for v in listV:
            listDuplicated.append(v)
    else:
        for v in listV:
            for ins in listIns:
                if ins in v:
                    continue
                listDuplicated.append(v)
    listClean =  [*set(listDuplicated)]
    #print(listClean)
    return listClean

def final_listVol():
    mergeList = list_volumes_id_name()
    compareList = name_matchVol()
    finalList = [tup for tup in mergeList if any(i in tup for i in compareList)]   
    return finalList

def print_listVol():
    list = final_listVol()
    return list_iterate_customer_unused(list)

def name_matchACL():
    listDuplicated = []
    listIns = instance_cut()
    listNacls = list_nacls()
    if not listIns:
        for nacl in listNacls:
            listDuplicated.append(nacl)
    else:
        for nacl in listNacls:
            for ins in listIns:
                if ins in nacl:
                    continue   
                listDuplicated.append(nacl)
    listClean =  [*set(listDuplicated)]
    #print(listClean)
    return listClean


def final_listACL():
    mergeList = list_nacls_id_name()
    compareList = name_matchACL()
    finalList = [tup for tup in mergeList if any(i in tup for i in compareList)]   
    return finalList

def print_listACL():
    list = final_listACL()
    return list_iterate_customer_unused(list)

def name_matchIG():
    listDuplicated = []
    listIns = instance_cut()
    listIg = list_internet_gateways()
    if not listIns:
        for ig in listIg:
            listDuplicated.append(ig)
    else:
        for ig in listIg:
            for ins in listIns:
                if ins in ig:
                    continue
                listDuplicated.append(ig)
    listClean = [*set(listDuplicated)]
    return listClean

def final_listIG():
    mergeList = list_internet_gateways_id_name()
    compareList = name_matchIG()
    finalList = [tup for tup in mergeList if any(i in tup for i in compareList)]   
    return finalList

def print_listIG():
    list = final_listIG()
    return list_iterate_customer_unused(list)

def name_matchRT():
    listDuplicated = []
    listIns = instance_cut()
    listRt = list_route_tables()
    if not listIns:
        for rt in listRt:
            listDuplicated.append(rt)
    else:
        for rt in listRt:
            for ins in listIns:
                if ins in rt:
                    continue
                listDuplicated.append(rt)
    listClean =  [*set(listDuplicated)]
    return listClean

def final_listRT():
    mergeList = list_route_tables_id_name()
    compareList = name_matchRT()
    finalList = [tup for tup in mergeList if any(i in tup for i in compareList)]
    return finalList

def print_listRT():
    list = final_listRT()
    return list_iterate_customer_unused(list)

def name_match_subnet():
    listDuplicated = []
    listIns = instance_cut()
    listSubnets = list_subnets()
    if not listIns:
        for subnet in listSubnets:
            listDuplicated.append(subnet)
    else:
        for subnet in listSubnets:
            for ins in listIns:
                if ins in subnet:
                    continue
                listDuplicated.append(subnet)
    listClean = [*set(listDuplicated)]
    return listClean

def final_list_subnet():
    mergeList = list_subnets_id_name()
    compareList = name_match_subnet()
    finalList = [tup for tup in mergeList if any(i in tup for i in compareList)]   
    return finalList

def print_list_subnet():
    list = final_list_subnet()
    return list_iterate_customer_unused(list)

def name_matchVPC():
    listDuplicated = []
    listIns = instance_cut()
    listVpcs = list_vpcs()
    if not listIns:
        for vpc in listVpcs:
            listDuplicated.append(vpc)
    else:
        for vpc in listVpcs:
            for ins in listIns:
                if ins in vpc:
                    continue
                listDuplicated.append(vpc)
    listClean = [*set(listDuplicated)]
    return listClean

def final_listVPC():
    mergeList = list_vpcs_id_name()
    compareList = name_matchVPC()
    finalList = [tup for tup in mergeList if any(i in tup for i in compareList)]   
    return finalList

def print_listVPC():
    list = final_listVPC()
    return list_iterate_customer_unused(list)

# Currently the Key pairs are not working.

def name_matchKP():
    listDuplicated = []
    listIns = instance_cut()
    listKP = list_key_pairs()
    if not listIns:
        for kp in listKP:
            listDuplicated.append(kp)
    else:
        for kp in listKP:
            for ins in listIns:
                if ins in kp:
                    continue
                listDuplicated.append(kp)
    listClean =  [*set(listDuplicated)]
    #print(listClean)
    return listClean

def final_listKP():
    mergeList = list_key_pairs_id_name()
    compareList = name_matchKP()
    finalList = [tup for tup in mergeList if any(i in tup for i in compareList)]   
    return finalList

def print_listKP():
    list = final_listKP()
    return list_iterate_customer_unused(list)

# Below is the UI, currently it is very Rudimentary

def start_output():
    set = True
    while set == True:
        print("\n")
        value = input("List of all resources or List of unused customer resources: ")
        if (value == "-all"):
            print("\n")
            print("Key for inputs: ")
            print("Security Groups: sg, Volumes: vol, ACLs: acl, Internet Gateways: ig, Route tables: rt")
            print("Subnets: subnets, VPCs: vpc, Instances: ins, Quit: q")
            print("\n")
            all_list()
            set = False
        elif (value == "-unused"):
            print("\n")
            print("Key for inputs: ")
            print("Security Groups: sg, Volumes: vol, ACLs: acl, Internet Gateways: ig, Route tables: rt")
            print("Subnets: subnets, VPCs: vpc, All resources: all, Quit: q")
            print("\n")
            unused()
            set = False
        
def all_list():
    set = True
    while set == True:
        Resource = input("Enter Resource Name: ")
        if Resource == ("ins"):
            list_iterate_customer_unused(list_instance_id_name())
        elif Resource == ("sg"):
            list_iterate_customer_unused(list_security_groups_id_name_full())
        elif Resource == ("vol"):
            list_iterate_customer_unused(list_volumes_id_name_full())
        elif Resource == ("acl"):
            list_iterate_customer_unused(list_nacls_id_name_full())
        elif Resource == ("ig"):
            list_iterate_customer_unused(list_internet_gateways_id_name_full())
        elif Resource == ("rt"):
            list_iterate_customer_unused(list_route_tables_id_name_full())
        elif Resource == ("subnet"):
            list_iterate_customer_unused(list_subnets_id_name_full())
        elif Resource == ("vpc"):
            list_iterate_customer_unused(list_vpcs_id_name_full())
        elif Resource == ("q"):
            set = False
            

def unused():
    set = True
    while set == True:
        Resource = input("Enter Resource Name: ")
        if Resource == ("all"):
            print("Secuirty Groups:")
            print_listSG()
            print("Volumes:")
            print_listVol()
            print("ACL:")
            print_listACL()
            print("Internet Gateways:")
            print_listIG()
            print("Route Tables:")
            print_listRT()
            print("Subnet")
            print_list_subnet()
            print("VPC:")
            print_listVPC()
            #print("Key Pairs:")
            #final_listKP()
        elif Resource == ("sg"):
            print_listSG()
        elif Resource == ("vol"):
            print_listVol()
        elif Resource == ("acl"):
            print_listACL()
        elif Resource == ("ig"):
            print_listIG()
        elif Resource == ("rt"):
            print_listRT()
        elif Resource == ("subnet"):
            print_list_subnet()
        elif Resource == ("vpc"):
            print_listVPC()
        #elif Resource == ("kp"):
            #print_listKP()
        elif Resource == ("q"):
            set = False

def main():
    print("\n")
    print("Instances: " + str(len(list_instance_id_name())) + " total | " + str(instance_state_count()) + " resources running.")
    print("Security Groups: " + str(len(list_security_groups_id_name_full())) + " total | "+ str(len(final_listSG())) + " unused customer resources")
    print("Volumes: " + str(len(list_volumes_id_name_full())) + " total | " + str(len(final_listVol())) + " unused customer resources")
    print("ACLs: " + str(len(list_nacls_id_name_full())) + " total | " + str(len(final_listACL())) + " unused customer resources")
    print("Internet Gateways: " + str(len(list_internet_gateways_id_name_full())) + " total | " + str(len(final_listIG())) + " unused customer resources")
    print("Route Tables: " + str(len(list_route_tables_id_name_full())) + " total | " + str(len(final_listRT())) + " unused customer resources")
    print("Subnets: " + str(len(list_subnets_id_name_full())) + " total | " + str(len(final_list_subnet())) + " unused customer resources")
    print("VPCs: " + str(len(list_vpcs_id_name_full())) + " total | " + str(len(final_listVPC())) + " unused customer resources")
    print("\n")
    print("Type -all to select list of all resources | type -unused to select list of unused resources | type -q to quit")
    start_output()
main()
