#!/bin/bash -f

# Copyright  2018-2023, Spillbox. All rights reserved.
# Property of Spillbox Inc.
# Any kind of copying or producing derivative work is prohibited without
# explicit written consent from Spillbox Inc.

#DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"
case "$0" in
        ./*|/*)
                DIR="$(realpath $(dirname $0))"
                 ;;
        -bash)
                echo "Do not source this file"
                return
                ;;
         *)
               tmp=$(which $0)
               DIR="$(realpath $(dirname $tmp))"
                 ;;
esac


if [ "$SPLAPP_DEBUG" != "" ]; then
    set -x
fi
if [ "${SPILLBOX_PROJECT}" == "" ]; then
    export SPILLBOX_PROJECT=default
fi
if [ "${CONFIGDIR=}" != "" ]; then
    CONFIGDIR="${SPILLBOX_CONFIGDIR}/.config/spillbox"
else
    CONFIGDIR="$HOME/.config/spillbox"
fi

workdir=$(realpath .)
status=$(grep -w $workdir ${CONFIGDIR}/${SPILLBOX_PROJECT}/workdir 2>/dev/null | wc -l)
if test ${status} -gt 0 ; then
    exit 0
fi

if [[ -z "${SPILLBOX_HYBRID_MOUNT_PATHS}" ]]; then
    export SPILLBOX_HYBRID_MOUNT_PATHS=`pwd`
fi
if [[ -z "${SPILLBOX_HYBRID_MOUNT_PATHS_EXCLUDE}" ]]; then
    export SPILLBOX_HYBRID_MOUNT_PATHS_EXCLUDE=PATH
fi

include=""
if [ "${SPILLBOX_HYBRID_MOUNT_PATHS}" != "" ]; then
    if [ "${SPILLBOX_HYBRID_MOUNT_PATHS}" != "NONE" ]; then
        if [ "${SPILLBOX_HYBRID_MOUNT_PATHS}" == "ALL" ]; then
            if [ -f "$CONFIGDIR/$SPILLBOX_PROJECT/mountpaths" ]; then
                cat $CONFIGDIR/$SPILLBOX_PROJECT/mountpaths | xargs $DIR/splrun project snapshot $SPILLBOX_PROJECT -hybrid-hier 
                cat $CONFIGDIR/$SPILLBOX_PROJECT/mountpaths | xargs echo SPILLBOX_HYBRID_MOUNT_PATHS=
            fi 
        else
            if [ "${SPILLBOX_HYBRID_MOUNT_PATHS}" != "" ]; then
                tp=$(cat $CONFIGDIR/$SPILLBOX_PROJECT/mountpaths | xargs)
                IFS=' ' read -ra MP <<< "$SPILLBOX_HYBRID_MOUNT_PATHS"
                for i in "${MP[@]}"; do
                    rp=$(realpath $i 2>/dev/null )
                    if [ "$rp" != "" ]; then
                        rplist=()
                        if [ -f "${i}/.spillbox_hybrid_path" ]; then
                            while IFS= read -r line; do
                                if [ -z "${line}" ]; then
                                    continue
                                fi
                                case $line in
                                    /*) rp=$(realpath $line 2>/dev/null )
                                        ;;
                                    *) rp=$(realpath $rp/$line 2>/dev/null )
                                        ;;
                                esac
                                if [ "$rp" != "" ]; then
                                    rplist+=($rp)
                                fi
                            done < ${i}/.spillbox_hybrid_path
                        else
                            rplist+=($rp)
                        fi
                        IFS=' ' read -ra TOPP <<< "$tp"
                        for j in "${TOPP[@]}"; do
                            for rpl in "${rplist[@]}"
                            do
                                status=$(echo ${rpl} | grep ^$j | wc -l)
                                if test ${status} -eq 1 ; then
                                    include="$include ${rpl}"
                                fi
                            done
                        done
                    fi
                done
                if [ "$include" != "" ]; then
                    $DIR/splrun project snapshot $SPILLBOX_PROJECT -hybrid-hier $include 
                    echo SPILLBOX_HYBRID_MOUNT_PATHS=$include
                fi
            fi
        fi
    fi
fi
echo $workdir $include >> $CONFIGDIR/$SPILLBOX_PROJECT/workdir
if [ "${SPILLBOX_HYBRID_MOUNT_PATHS_EXCLUDE}" != "" ]; then
    excludeall=""
    exclude=""
    if [ "${SPILLBOX_HYBRID_MOUNT_PATHS_EXCLUDE}" == "PATH" ]; then
        excludeall=$(echo $PATH | sed 's/:/ /g') 
    else
        excludeall="${SPILLBOX_HYBRID_MOUNT_PATHS_EXCLUDE}"
    fi

    if [ "${excludeall}" != "" ]; then 
        tp=$(cat $CONFIGDIR/$SPILLBOX_PROJECT/mountpaths | xargs)
        IFS=' ' read -ra MP <<< "${excludeall}"
        for i in "${MP[@]}"; do
            if [ "$i" == "." ]; then
                continue
            fi
            rp=$(realpath $i 2>/dev/null )
            if [ "$rp" != "" ]; then
                IFS=' ' read -ra TOPP <<< "$tp"
                for j in "${TOPP[@]}"; do
                    status=$(echo $rp | grep -w $j | wc -l)
                    if test ${status} -eq 1 ; then
                        exclude="$exclude $rp"
                        break
                    fi
                done
            fi
        done
    fi
    if [ "${exclude}" != "" ]; then 
        $DIR/splrun project snapshot $SPILLBOX_PROJECT -hybrid-remove $exclude 
        echo SPILLBOX_HYBRID_MOUNT_PATHS_EXCLUDE=$exclude
    fi
fi
