#!/bin/bash -f

# Copyright  2018-2023, Spillbox. All rights reserved.
# Property of Spillbox Inc.
# Any kind of copying or producing derivative work is prohibited without
# explicit written consent from Spillbox Inc.

#DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"
case "$0" in
        ./*|/*)
                DIR="$(realpath $(dirname $0))"
                 ;;
        -bash)
                echo "Do not source this file"
                return
                ;;
         *)
               tmp=$(which $0)
               DIR="$(realpath $(dirname $tmp))"
                 ;;
esac

idletimeout=36
if [ "$SPILLBOX_IDLE_TIMEOUT" != "" ]; then
    idletimeout=$SPILLBOX_IDLE_TIMEOUT
fi

if [ "$SPLAPP_DEBUG" != "" ]; then
    set -x
fi
if [ "${SPILLBOX_PROJECT}" == "" ]; then
    export SPILLBOX_PROJECT=default
fi
if [ "${SPILLBOX_CONFIGDIR=}" != "" ]; then
    CONFIGDIR="${SPILLBOX_CONFIGDIR}/.config/spillbox"
else
    CONFIGDIR="$HOME/.config/spillbox"
fi
status=$(grep current ${CONFIGDIR}/${SPILLBOX_PROJECT}/status 2>/dev/null | grep applied | wc -l)
if [ "${status}" == "1" ]; then
    exit 0
else 
    if [ -f "${CONFIGDIR}/${SPILLBOX_PROJECT}/ppid" ]; then
        last_pid=$(cat ${CONFIGDIR}/${SPILLBOX_PROJECT}/ppid)
        if [ "$SPILLBOX_PROJECT_CREATOR_PID" == "$last_pid" ]; then
            echo "project $SPILLBOX_PROJECT failed previously, status: ${status}"
            echo "Please delete file ${CONFIGDIR}/${SPILLBOX_PROJECT}/ppid to recreate the project"
            exit 1
        fi
    fi
fi
echo "Creating spillbox project $SPILLBOX_PROJECT ..."

if [ "${SPLAPP_ENABLE_AUTO_HYBRID}" != "" ]; then
    if [[ -z "${SPILLBOX_HYBRID_MOUNT_PATHS}" ]]; then
        export SPILLBOX_HYBRID_MOUNT_PATHS=`pwd`
    fi
    echo SPILLBOX_HYBRID_MOUNT_PATHS=$SPILLBOX_HYBRID_MOUNT_PATHS
    if [[ -z "${SPILLBOX_HYBRID_MOUNT_PATHS_EXCLUDE}" ]]; then
        export SPILLBOX_HYBRID_MOUNT_PATHS_EXCLUDE=PATH
    fi
    echo SPILLBOX_HYBRID_MOUNT_PATHS_EXCLUDE=$SPILLBOX_HYBRID_MOUNT_PATHS_EXCLUDE
fi

$DIR/splrun project apply $SPILLBOX_PROJECT ${SPLAPP_AUTO_CONFIG}
ret=$?
if [ "$ret" == "0" ]; then
    echo "Setting idletimeout to $idletimeout hr" >&2
    $DIR/splrun project idletimeout  $idletimeout
fi
echo "$SPILLBOX_PROJECT_CREATOR_PID" > ${CONFIGDIR}/${SPILLBOX_PROJECT}/ppid
echo "Project creation done" >&2
exit $ret
