#!/bin/bash -f

# Copyright © 2018-2023, Spillbox. All rights reserved.
# Property of Spillbox Inc.
# Any kind of copying or producing derivative work is prohibited without
# explicit written consent from Spillbox Inc.

basedir="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"
lmutil=""
plat=$(uname -s)
mplat=""
vport=""
case "$plat" in
    Darwin)
        mplat="darwin"
        ;;
    Linux)
        mplat="linux"
        ;;
    *)
        echo "error: Unsupported Platform" >&2
        exit 1
esac

if [ -f "$basedir/lmutil-$mplat-amd64" ] ; then
    lmutil=$basedir/lmutil-$mplat-amd64
elif [ -f "$basedir/lmutil" ] ; then
    lmutil=$basedir/lmutil
else
    echo "error: Missing installation file: lmutil" >&2
    exit 1
fi

if [[ -z "${SPILLBOX_LICENSE_FILE}" ]]; then
    echo "error: Please set env SPILLBOX_LICENSE_FILE" >&2
fi

lic=$(echo $SPILLBOX_LICENSE_FILE | tr ":" "\n")
re='^[0-9]+$'
strace=$(which strace)
if [ "$strace" == "" ] ; then
    echo "error: strace not available" >&2
    exit 1
fi

for alic in $lic
do
    valid=$($lmutil lmdiag -c $alic -n |& grep "License file")
    if [ "$valid" == "" ] ; then
        echo "error: invalid license $alic" >&2
        continue
    fi
    IFS="@" read -r port host <<< "$alic"
    if [[ "$port" == "" || "$host" == "" ]] ; then
        echo "error: Invalid entry $alic in env SPILLBOX_LICENSE_FILE" >&2
        continue
    fi
    if ! [[ $port =~ $re ]] ; then
        echo "error: Not a number, $port in SPILLBOX_LICENSE_FILE" >&2;
        continue
    fi
    tmpvport=$($strace $lmutil lmdiag -c $alic -n |& egrep 'sin_port=htons(.*)' | awk -F= '{print $3}' | sed 's/[a-z,()_]//g' | sort -u | grep -v -w $port | sed 's/ //g')
    if [ "$tmpvport" == "" ] ; then
        echo "error: failed to find vendor port for license server $alc" >&2
        continue
    fi
    if [ "$vport" == "" ] ; then
        vport=$(echo $tmpvport@$host)
    else
        vport=$(echo $vport:$tmpvport@$host)
    fi
done
echo -n $vport
