#!/bin/bash -f

# Copyright © 2018-2023, Spillbox. All rights reserved.
# Property of Spillbox Inc.
# Any kind of copying or producing derivative work is prohibited without
# explicit written consent from Spillbox Inc.

umask 022
DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"
cd $DIR
RETVAL=$? 
if test ${RETVAL} -ne 0 ; then
    echo "cannot change directory $DIR" >&2
    exit $RETVAL
fi

if [ -f $PWD/splfs.tar.gz ];then
         mkdir -p old_splfs
	 mv splfs.tar.gz old_splfs/splfs.tar.gz
fi

name=`uname`  
if [ "${SPILLBOX_VPN}" != "" ]; then
    echo "Env SPILLBOX_VPN set. Assuming VPN flow."
    set -x
	curl -o splfs.tar.gz https://s3-us-west-1.amazonaws.com/spillbox.io-public/spill-dc/v1.3/splfs.tar.gz
else
    echo -n "Is this VPN flow ?(y/n): "
    read varflow

    case "$varflow" in
        y) 
            set -x
            curl -o splfs.tar.gz https://s3-us-west-1.amazonaws.com/spillbox.io-public/spill-dc/v1.3/splfs.tar.gz    
            ;;
        n)
            set -x
	        if [ "${name}" == "Darwin" ]; then
		        curl -o splfs.tar.gz https://s3-us-west-1.amazonaws.com/spillbox.io-public-darwin/v1.3/splfs.tar.gz
	        elif [ "${name}" == "Linux" ]; then
		        curl -o splfs.tar.gz https://s3-us-west-1.amazonaws.com/spillbox.io-public-linux-amd64/v1.3/splfs.tar.gz
	        else
		        curl -o splfs.tar.gz https://s3-us-west-1.amazonaws.com/spillbox.io-public-linux-arm64/v1.3/splfs.tar.gz
	        fi
            ;;
        *)
            echo "Error in user response"
            exit 1
            ;;
    esac
fi
 tar xvfz splfs.tar.gz
